#ifndef RWEXP_CHARACTERSTUDIO_H
#define RWEXP_CHARACTERSTUDIO_H

/*
Character Studio support here.
Code clean up goal: less functionality should be exported from characterstudio.cpp
and instead more functionality moved into characterstudio.cpp
*/

#include <set>

extern bool
IsABipedNode( INode *node );

extern bool
IsAFootstepNode( INode *node );

extern Modifier *
FindPhysiqueModifier (INode* nodePtr);

extern char *
FindBipedNameInHierarchy(INode *root);

#include "RwExpError.h"

typedef std::set<INode *> SkinsContainer;
typedef std::set<INode *> BonesContainer;

class WarningList;

extern RwExpError FindPhysiqueAndBipedNodes(
    Interface *gi,                  //for determining version # from character studio
    WarningList *warningList,       //for recording version number of character studio for diagnostics
    INode *sceneRoot,               //input - root of entire MAX scene.
    INode *topOfSelectedHierarchy,  //input - highest node in heirarchy user selected.

    //output: all physiques we think are worth exporting
    SkinsContainer & skinsToExport,

    //output: all bones (biped parts, dummies, etc)
    //that influence any vertex in any of the above physiques
    BonesContainer & influentialBones
    );

class DFFExport;

#include "rwcore.h"
#include "rpworld.h"

//turn these physiques into atomics
extern
void ProcessPhysiqueNodes( DFFExport *dffExp, SkinsContainer & skins, INode *rootNode, RpClump *clump );

#endif
